package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoomList;
import odata.msgraph.client.beta.entity.collection.request.RoomCollectionRequest;

@JsonIgnoreType
public class RoomListRequest extends EntityRequest<RoomList> {

    public RoomListRequest(ContextPath contextPath, Optional<Object> value) {
        super(RoomList.class, contextPath, value, false);
    }

    public RoomRequest rooms(String id) {
        return new RoomRequest(contextPath.addSegment("rooms").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoomCollectionRequest rooms() {
        return new RoomCollectionRequest(
                        contextPath.addSegment("rooms"), Optional.empty());
    }

}
