package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoleScopeTag;
import odata.msgraph.client.beta.entity.RoleScopeTagAutoAssignment;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagAutoAssignmentCollectionRequest;

@JsonIgnoreType
public class RoleScopeTagRequest extends EntityRequest<RoleScopeTag> {

    public RoleScopeTagRequest(ContextPath contextPath, Optional<Object> value) {
        super(RoleScopeTag.class, contextPath, value, false);
    }

    public RoleScopeTagAutoAssignmentRequest assignments(String id) {
        return new RoleScopeTagAutoAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleScopeTagAutoAssignmentCollectionRequest assignments() {
        return new RoleScopeTagAutoAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTagAutoAssignment> assign(List<RoleScopeTagAutoAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.roleScopeTagAutoAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), RoleScopeTagAutoAssignment.class, _parameters);
    }

}
