package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoleManagement;

@JsonIgnoreType
public class RoleManagementRequest extends EntityRequest<RoleManagement> {

    public RoleManagementRequest(ContextPath contextPath, Optional<Object> value) {
        super(RoleManagement.class, contextPath, value, false);
    }

    public RbacApplicationRequest directory() {
        return new RbacApplicationRequest(contextPath.addSegment("directory"), Optional.empty());
    }

    public RbacApplicationMultipleRequest cloudPC() {
        return new RbacApplicationMultipleRequest(contextPath.addSegment("cloudPC"), Optional.empty());
    }

    public RbacApplicationRequest entitlementManagement() {
        return new RbacApplicationRequest(contextPath.addSegment("entitlementManagement"), Optional.empty());
    }

    public RbacApplicationMultipleRequest deviceManagement() {
        return new RbacApplicationMultipleRequest(contextPath.addSegment("deviceManagement"), Optional.empty());
    }

}
