package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoleDefinition;
import odata.msgraph.client.beta.entity.collection.request.RoleAssignmentCollectionRequest;

@JsonIgnoreType
public class RoleDefinitionRequest extends EntityRequest<RoleDefinition> {

    public RoleDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(RoleDefinition.class, contextPath, value, false);
    }

    public RoleAssignmentRequest roleAssignments(String id) {
        return new RoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleAssignmentCollectionRequest roleAssignments() {
        return new RoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.empty());
    }

}
