package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RiskyServicePrincipal;
import odata.msgraph.client.beta.entity.collection.request.RiskyServicePrincipalHistoryItemCollectionRequest;

@JsonIgnoreType
public class RiskyServicePrincipalRequest extends EntityRequest<RiskyServicePrincipal> {

    public RiskyServicePrincipalRequest(ContextPath contextPath, Optional<Object> value) {
        super(RiskyServicePrincipal.class, contextPath, value, false);
    }

    public RiskyServicePrincipalHistoryItemRequest history(String id) {
        return new RiskyServicePrincipalHistoryItemRequest(contextPath.addSegment("history").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyServicePrincipalHistoryItemCollectionRequest history() {
        return new RiskyServicePrincipalHistoryItemCollectionRequest(
                        contextPath.addSegment("history"), Optional.empty());
    }

}
