package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ArchivedPrintJob;
import odata.msgraph.client.beta.complex.AttackSimulationRepeatOffender;
import odata.msgraph.client.beta.complex.AttackSimulationSimulationUserCoverage;
import odata.msgraph.client.beta.complex.AttackSimulationTrainingUserCoverage;
import odata.msgraph.client.beta.complex.Report;
import odata.msgraph.client.beta.entity.ApplicationSignInSummary;
import odata.msgraph.client.beta.entity.AzureADFeatureUsage;
import odata.msgraph.client.beta.entity.AzureADLicenseUsage;
import odata.msgraph.client.beta.entity.AzureADUserFeatureUsage;
import odata.msgraph.client.beta.entity.CredentialUsageSummary;
import odata.msgraph.client.beta.entity.CredentialUserRegistrationCount;
import odata.msgraph.client.beta.entity.Office365ActiveUserCounts;
import odata.msgraph.client.beta.entity.Office365ActiveUserDetail;
import odata.msgraph.client.beta.entity.Office365GroupsActivityCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityDetail;
import odata.msgraph.client.beta.entity.Office365GroupsActivityFileCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityGroupCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityStorage;
import odata.msgraph.client.beta.entity.Office365ServicesUserCounts;
import odata.msgraph.client.beta.entity.RelyingPartyDetailedSummary;
import odata.msgraph.client.beta.entity.ReportRoot;
import odata.msgraph.client.beta.entity.collection.request.ApplicationSignInDetailedSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CredentialUserRegistrationDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageByPrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageByUserCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCredentialUsageDetailsCollectionRequest;

@JsonIgnoreType
public class ReportRootRequest extends EntityRequest<ReportRoot> {

    public ReportRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(ReportRoot.class, contextPath, value, false);
    }

    public ApplicationSignInDetailedSummaryRequest applicationSignInDetailedSummary(String id) {
        return new ApplicationSignInDetailedSummaryRequest(contextPath.addSegment("applicationSignInDetailedSummary").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApplicationSignInDetailedSummaryCollectionRequest applicationSignInDetailedSummary() {
        return new ApplicationSignInDetailedSummaryCollectionRequest(
                        contextPath.addSegment("applicationSignInDetailedSummary"), Optional.empty());
    }

    public AuthenticationMethodsRootRequest authenticationMethods() {
        return new AuthenticationMethodsRootRequest(contextPath.addSegment("authenticationMethods"), Optional.empty());
    }

    public CredentialUserRegistrationDetailsRequest credentialUserRegistrationDetails(String id) {
        return new CredentialUserRegistrationDetailsRequest(contextPath.addSegment("credentialUserRegistrationDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CredentialUserRegistrationDetailsCollectionRequest credentialUserRegistrationDetails() {
        return new CredentialUserRegistrationDetailsCollectionRequest(
                        contextPath.addSegment("credentialUserRegistrationDetails"), Optional.empty());
    }

    public UserCredentialUsageDetailsRequest userCredentialUsageDetails(String id) {
        return new UserCredentialUsageDetailsRequest(contextPath.addSegment("userCredentialUsageDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCredentialUsageDetailsCollectionRequest userCredentialUsageDetails() {
        return new UserCredentialUsageDetailsCollectionRequest(
                        contextPath.addSegment("userCredentialUsageDetails"), Optional.empty());
    }

    public PrintUsageByPrinterRequest dailyPrintUsageByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("dailyPrintUsageByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest dailyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest dailyPrintUsageByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("dailyPrintUsageByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest dailyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest dailyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest dailyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest dailyPrintUsageSummariesByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest dailyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest monthlyPrintUsageByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("monthlyPrintUsageByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest monthlyPrintUsageByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest monthlyPrintUsageByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("monthlyPrintUsageByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest monthlyPrintUsageByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageByUser"), Optional.empty());
    }

    public PrintUsageByPrinterRequest monthlyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageByPrinterRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByPrinterCollectionRequest monthlyPrintUsageSummariesByPrinter() {
        return new PrintUsageByPrinterCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByPrinter"), Optional.empty());
    }

    public PrintUsageByUserRequest monthlyPrintUsageSummariesByUser(String id) {
        return new PrintUsageByUserRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintUsageByUserCollectionRequest monthlyPrintUsageSummariesByUser() {
        return new PrintUsageByUserCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByUser"), Optional.empty());
    }

    @Function(name = "getAzureADApplicationSignInSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ApplicationSignInSummary> getAzureADApplicationSignInSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADApplicationSignInSummary"), ApplicationSignInSummary.class, _parameters);
    }

    @Function(name = "getAzureADFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADFeatureUsage> getAzureADFeatureUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADFeatureUsage"), AzureADFeatureUsage.class, _parameters);
    }

    @Function(name = "getAzureADLicenseUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADLicenseUsage> getAzureADLicenseUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADLicenseUsage"), AzureADLicenseUsage.class, _parameters);
    }

    @Function(name = "getAzureADUserFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADUserFeatureUsage> getAzureADUserFeatureUsage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADUserFeatureUsage"), AzureADUserFeatureUsage.class, _parameters);
    }

    @Function(name = "getCredentialUsageSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUsageSummary> getCredentialUsageSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUsageSummary"), CredentialUsageSummary.class, _parameters);
    }

    @Function(name = "getCredentialUserRegistrationCount")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUserRegistrationCount> getCredentialUserRegistrationCount() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUserRegistrationCount"), CredentialUserRegistrationCount.class, _parameters);
    }

    @Function(name = "getRelyingPartyDetailedSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RelyingPartyDetailedSummary> getRelyingPartyDetailedSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRelyingPartyDetailedSummary"), RelyingPartyDetailedSummary.class, _parameters);
    }

    @Function(name = "deviceConfigurationDeviceActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationDeviceActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationDeviceActivity"), Report.class, _parameters);
    }

    @Function(name = "deviceConfigurationUserActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationUserActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationUserActivity"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentDetails(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentSummary(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentSummary"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails_Function(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentFailureTrends")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureTrends() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureTrends"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters);
    }

    @Function(name = "getBrowserDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserDistributionUserCounts"), _parameters);
    }

    @Function(name = "getBrowserUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserUserCounts"), _parameters);
    }

    @Function(name = "getBrowserUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getBrowserUserDetail(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getBrowserUserDetail"), _parameters);
    }

    @Function(name = "getEmailActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityCounts"), _parameters);
    }

    @Function(name = "getEmailActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserCounts"), _parameters);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), _parameters);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageAppsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageAppsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageAppsUserCounts"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserCounts"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), _parameters);
    }

    @Function(name = "getEmailAppUsageVersionsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getEmailAppUsageVersionsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageVersionsUserCounts"), _parameters);
    }

    @Function(name = "getM365AppPlatformUserCounts")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppPlatformUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppPlatformUserCounts"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserCounts")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserCounts"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserDetail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserDetail"), Report.class, _parameters);
    }

    @Function(name = "getM365AppUserDetail")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getM365AppUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getM365AppUserDetail"), Report.class, _parameters);
    }

    @Function(name = "getMailboxUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageDetail(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageDetail"), _parameters);
    }

    @Function(name = "getMailboxUsageMailboxCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageMailboxCounts"), _parameters);
    }

    @Function(name = "getMailboxUsageQuotaStatusMailboxCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageQuotaStatusMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageQuotaStatusMailboxCounts"), _parameters);
    }

    @Function(name = "getMailboxUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getMailboxUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageStorage"), _parameters);
    }

    @Function(name = "getOffice365ActivationCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationCounts"), _parameters);
    }

    @Function(name = "getOffice365ActivationsUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationsUserCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserCounts"), _parameters);
    }

    @Function(name = "getOffice365ActivationsUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOffice365ActivationsUserDetail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserDetail"), _parameters);
    }

    @Function(name = "getOffice365ActiveUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserCounts> getOffice365ActiveUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserCounts"), Office365ActiveUserCounts.class, _parameters);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityCounts> getOffice365GroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityCounts"), Office365GroupsActivityCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityFileCounts> getOffice365GroupsActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityFileCounts"), Office365GroupsActivityFileCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityGroupCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityGroupCounts> getOffice365GroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityGroupCounts"), Office365GroupsActivityGroupCounts.class, _parameters);
    }

    @Function(name = "getOffice365GroupsActivityStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityStorage> getOffice365GroupsActivityStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityStorage"), Office365GroupsActivityStorage.class, _parameters);
    }

    @Function(name = "getOffice365ServicesUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ServicesUserCounts> getOffice365ServicesUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ServicesUserCounts"), Office365ServicesUserCounts.class, _parameters);
    }

    @Function(name = "getOneDriveActivityFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityFileCounts"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserCounts"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), _parameters);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountCounts"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageAccountDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), _parameters);
    }

    @Function(name = "getOneDriveUsageFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageFileCounts"), _parameters);
    }

    @Function(name = "getOneDriveUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getOneDriveUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageStorage"), _parameters);
    }

    @Function(name = "getSharePointActivityFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityFileCounts"), _parameters);
    }

    @Function(name = "getSharePointActivityPages")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityPages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityPages"), _parameters);
    }

    @Function(name = "getSharePointActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserCounts"), _parameters);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), _parameters);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageFileCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageFileCounts"), _parameters);
    }

    @Function(name = "getSharePointSiteUsagePages")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsagePages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsagePages"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageSiteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageSiteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageSiteCounts"), _parameters);
    }

    @Function(name = "getSharePointSiteUsageStorage")
    @JsonIgnore
    public FunctionRequestReturningStream getSharePointSiteUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageStorage"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessOrganizerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessParticipantActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityUserCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityMinuteCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityMinuteCounts"), _parameters);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getSkypeForBusinessPeerToPeerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageDistributionTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageDistributionTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageDistributionTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityCounts"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDetail"), _parameters);
    }

    @Function(name = "getTeamsTeamActivityDistributionCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsTeamActivityDistributionCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsTeamActivityDistributionCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityDistributionTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityDistributionTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityDistributionTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityDistributionUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalDistributionCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalDistributionCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalDistributionCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityTotalUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityTotalUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityTotalUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserCounts"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), _parameters);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getTeamsUserActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityCounts"), _parameters);
    }

    @Function(name = "getYammerActivityUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserCounts"), _parameters);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageDistributionUserCounts"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserCounts"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityCounts"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), _parameters);
    }

    @Function(name = "getYammerGroupsActivityGroupCounts")
    @JsonIgnore
    public FunctionRequestReturningStream getYammerGroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningStream(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityGroupCounts"), _parameters);
    }

    @Function(name = "getGroupArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getGroupArchivedPrintJobs(String groupId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGroupArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getPrinterArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getPrinterArchivedPrintJobs(String printerId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(printerId, "printerId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("printerId", "Edm.String", Checks.checkIsAscii(printerId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrinterArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getUserArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getUserArchivedPrintJobs(String userId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(userId, "userId cannot be null");
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserArchivedPrintJobs"), ArchivedPrintJob.class, _parameters);
    }

    @Function(name = "getTenantSecureScores")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getTenantSecureScores(Integer period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.Int32", period)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTenantSecureScores"), Report.class, _parameters);
    }

    @Function(name = "getAttackSimulationRepeatOffenders")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationRepeatOffender> getAttackSimulationRepeatOffenders() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationRepeatOffenders"), AttackSimulationRepeatOffender.class, _parameters);
    }

    @Function(name = "getAttackSimulationSimulationUserCoverage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationSimulationUserCoverage> getAttackSimulationSimulationUserCoverage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationSimulationUserCoverage"), AttackSimulationSimulationUserCoverage.class, _parameters);
    }

    @Function(name = "getAttackSimulationTrainingUserCoverage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AttackSimulationTrainingUserCoverage> getAttackSimulationTrainingUserCoverage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAttackSimulationTrainingUserCoverage"), AttackSimulationTrainingUserCoverage.class, _parameters);
    }

}
