package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RecommendationResource;

@JsonIgnoreType
public class RecommendationResourceRequest extends EntityRequest<RecommendationResource> {

    public RecommendationResourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(RecommendationResource.class, contextPath, value, false);
    }

    @Action(name = "complete")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> complete() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.complete"), RecommendationResource.class, _parameters);
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> dismiss(String dismissReason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("dismissReason", "Edm.String", Checks.checkIsAscii(dismissReason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), RecommendationResource.class, _parameters);
    }

    @Action(name = "postpone")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> postpone(OffsetDateTime postponeUntilDateTime) {
        Preconditions.checkNotNull(postponeUntilDateTime, "postponeUntilDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("postponeUntilDateTime", "Edm.DateTimeOffset", postponeUntilDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postpone"), RecommendationResource.class, _parameters);
    }

    @Action(name = "reactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RecommendationResource> reactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<RecommendationResource>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reactivate"), RecommendationResource.class, _parameters);
    }

}
