package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PurchaseInvoice;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;

@JsonIgnoreType
public class PurchaseInvoiceRequest extends EntityRequest<PurchaseInvoice> {

    public PurchaseInvoiceRequest(ContextPath contextPath, Optional<Object> value) {
        super(PurchaseInvoice.class, contextPath, value, false);
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.empty());
    }

    public PurchaseInvoiceLineRequest purchaseInvoiceLines(String id) {
        return new PurchaseInvoiceLineRequest(contextPath.addSegment("purchaseInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PurchaseInvoiceLineCollectionRequest purchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"), Optional.empty());
    }

    public VendorRequest vendor() {
        return new VendorRequest(contextPath.addSegment("vendor"), Optional.empty());
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

}
