package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PurchaseInvoiceLine;

@JsonIgnoreType
public class PurchaseInvoiceLineRequest extends EntityRequest<PurchaseInvoiceLine> {

    public PurchaseInvoiceLineRequest(ContextPath contextPath, Optional<Object> value) {
        super(PurchaseInvoiceLine.class, contextPath, value, false);
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"), Optional.empty());
    }

    public ItemRequest item() {
        return new ItemRequest(contextPath.addSegment("item"), Optional.empty());
    }

}
