package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PublishedResource;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;

@JsonIgnoreType
public class PublishedResourceRequest extends EntityRequest<PublishedResource> {

    public PublishedResourceRequest(ContextPath contextPath, Optional<Object> value) {
        super(PublishedResource.class, contextPath, value, false);
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"), Optional.empty());
    }

}
