package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Program;
import odata.msgraph.client.beta.entity.collection.request.ProgramControlCollectionRequest;

@JsonIgnoreType
public class ProgramRequest extends EntityRequest<Program> {

    public ProgramRequest(ContextPath contextPath, Optional<Object> value) {
        super(Program.class, contextPath, value, false);
    }

    public ProgramControlRequest controls(String id) {
        return new ProgramControlRequest(contextPath.addSegment("controls").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProgramControlCollectionRequest controls() {
        return new ProgramControlCollectionRequest(
                        contextPath.addSegment("controls"), Optional.empty());
    }

}
