package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Profile;
import odata.msgraph.client.beta.entity.collection.request.EducationalActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemAddressCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemEmailCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPatentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPhoneCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPublicationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LanguageProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnotationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnualEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAwardCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonCertificationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonInterestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonNameCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonWebsiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProjectParticipationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SkillProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAccountInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WebAccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkPositionCollectionRequest;

@JsonIgnoreType
public class ProfileRequest extends EntityRequest<Profile> {

    public ProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Profile.class, contextPath, value, false);
    }

    public UserAccountInformationRequest account(String id) {
        return new UserAccountInformationRequest(contextPath.addSegment("account").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserAccountInformationCollectionRequest account() {
        return new UserAccountInformationCollectionRequest(
                        contextPath.addSegment("account"), Optional.empty());
    }

    public ItemAddressRequest addresses(String id) {
        return new ItemAddressRequest(contextPath.addSegment("addresses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemAddressCollectionRequest addresses() {
        return new ItemAddressCollectionRequest(
                        contextPath.addSegment("addresses"), Optional.empty());
    }

    public PersonAnnualEventRequest anniversaries(String id) {
        return new PersonAnnualEventRequest(contextPath.addSegment("anniversaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonAnnualEventCollectionRequest anniversaries() {
        return new PersonAnnualEventCollectionRequest(
                        contextPath.addSegment("anniversaries"), Optional.empty());
    }

    public PersonAwardRequest awards(String id) {
        return new PersonAwardRequest(contextPath.addSegment("awards").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonAwardCollectionRequest awards() {
        return new PersonAwardCollectionRequest(
                        contextPath.addSegment("awards"), Optional.empty());
    }

    public PersonCertificationRequest certifications(String id) {
        return new PersonCertificationRequest(contextPath.addSegment("certifications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonCertificationCollectionRequest certifications() {
        return new PersonCertificationCollectionRequest(
                        contextPath.addSegment("certifications"), Optional.empty());
    }

    public EducationalActivityRequest educationalActivities(String id) {
        return new EducationalActivityRequest(contextPath.addSegment("educationalActivities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationalActivityCollectionRequest educationalActivities() {
        return new EducationalActivityCollectionRequest(
                        contextPath.addSegment("educationalActivities"), Optional.empty());
    }

    public ItemEmailRequest emails(String id) {
        return new ItemEmailRequest(contextPath.addSegment("emails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemEmailCollectionRequest emails() {
        return new ItemEmailCollectionRequest(
                        contextPath.addSegment("emails"), Optional.empty());
    }

    public PersonInterestRequest interests(String id) {
        return new PersonInterestRequest(contextPath.addSegment("interests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonInterestCollectionRequest interests() {
        return new PersonInterestCollectionRequest(
                        contextPath.addSegment("interests"), Optional.empty());
    }

    public LanguageProficiencyRequest languages(String id) {
        return new LanguageProficiencyRequest(contextPath.addSegment("languages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LanguageProficiencyCollectionRequest languages() {
        return new LanguageProficiencyCollectionRequest(
                        contextPath.addSegment("languages"), Optional.empty());
    }

    public PersonNameRequest names(String id) {
        return new PersonNameRequest(contextPath.addSegment("names").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonNameCollectionRequest names() {
        return new PersonNameCollectionRequest(
                        contextPath.addSegment("names"), Optional.empty());
    }

    public PersonAnnotationRequest notes(String id) {
        return new PersonAnnotationRequest(contextPath.addSegment("notes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonAnnotationCollectionRequest notes() {
        return new PersonAnnotationCollectionRequest(
                        contextPath.addSegment("notes"), Optional.empty());
    }

    public ItemPatentRequest patents(String id) {
        return new ItemPatentRequest(contextPath.addSegment("patents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemPatentCollectionRequest patents() {
        return new ItemPatentCollectionRequest(
                        contextPath.addSegment("patents"), Optional.empty());
    }

    public ItemPhoneRequest phones(String id) {
        return new ItemPhoneRequest(contextPath.addSegment("phones").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemPhoneCollectionRequest phones() {
        return new ItemPhoneCollectionRequest(
                        contextPath.addSegment("phones"), Optional.empty());
    }

    public WorkPositionRequest positions(String id) {
        return new WorkPositionRequest(contextPath.addSegment("positions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkPositionCollectionRequest positions() {
        return new WorkPositionCollectionRequest(
                        contextPath.addSegment("positions"), Optional.empty());
    }

    public ProjectParticipationRequest projects(String id) {
        return new ProjectParticipationRequest(contextPath.addSegment("projects").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProjectParticipationCollectionRequest projects() {
        return new ProjectParticipationCollectionRequest(
                        contextPath.addSegment("projects"), Optional.empty());
    }

    public ItemPublicationRequest publications(String id) {
        return new ItemPublicationRequest(contextPath.addSegment("publications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemPublicationCollectionRequest publications() {
        return new ItemPublicationCollectionRequest(
                        contextPath.addSegment("publications"), Optional.empty());
    }

    public SkillProficiencyRequest skills(String id) {
        return new SkillProficiencyRequest(contextPath.addSegment("skills").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SkillProficiencyCollectionRequest skills() {
        return new SkillProficiencyCollectionRequest(
                        contextPath.addSegment("skills"), Optional.empty());
    }

    public WebAccountRequest webAccounts(String id) {
        return new WebAccountRequest(contextPath.addSegment("webAccounts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WebAccountCollectionRequest webAccounts() {
        return new WebAccountCollectionRequest(
                        contextPath.addSegment("webAccounts"), Optional.empty());
    }

    public PersonWebsiteRequest websites(String id) {
        return new PersonWebsiteRequest(contextPath.addSegment("websites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PersonWebsiteCollectionRequest websites() {
        return new PersonWebsiteCollectionRequest(
                        contextPath.addSegment("websites"), Optional.empty());
    }

}
