package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrivilegedRole;
import odata.msgraph.client.beta.entity.PrivilegedRoleAssignment;
import odata.msgraph.client.beta.entity.collection.request.PrivilegedRoleAssignmentCollectionRequest;

@JsonIgnoreType
public class PrivilegedRoleRequest extends EntityRequest<PrivilegedRole> {

    public PrivilegedRoleRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrivilegedRole.class, contextPath, value, false);
    }

    public PrivilegedRoleAssignmentRequest assignments(String id) {
        return new PrivilegedRoleAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedRoleAssignmentCollectionRequest assignments() {
        return new PrivilegedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public PrivilegedRoleSettingsRequest settings() {
        return new PrivilegedRoleSettingsRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    public PrivilegedRoleSummaryRequest summary() {
        return new PrivilegedRoleSummaryRequest(contextPath.addSegment("summary"), Optional.empty());
    }

    @Action(name = "selfActivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> selfActivate(String reason, String duration, String ticketNumber, String ticketSystem) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .put("duration", "Edm.String", Checks.checkIsAscii(duration))
            .put("ticketNumber", "Edm.String", Checks.checkIsAscii(ticketNumber))
            .put("ticketSystem", "Edm.String", Checks.checkIsAscii(ticketSystem))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.selfActivate"), PrivilegedRoleAssignment.class, _parameters);
    }

    @Action(name = "selfDeactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> selfDeactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.selfDeactivate"), PrivilegedRoleAssignment.class, _parameters);
    }

}
