package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignmentRequest;

@JsonIgnoreType
public class PrivilegedRoleAssignmentRequestRequest extends EntityRequest<PrivilegedRoleAssignmentRequest> {

    public PrivilegedRoleAssignmentRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrivilegedRoleAssignmentRequest.class, contextPath, value, false);
    }

    public PrivilegedRoleRequest roleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest> cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), PrivilegedRoleAssignmentRequest.class, _parameters);
    }

}
