package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrinterShare;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;

@JsonIgnoreType
public class PrinterShareRequest extends EntityRequest<PrinterShare> {

    public PrinterShareRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrinterShare.class, contextPath, value, false);
    }

    public GroupRequest allowedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest allowedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("allowedGroups"), Optional.empty());
    }

    public UserRequest allowedUsers(String id) {
        return new UserRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest allowedUsers() {
        return new UserCollectionRequest(
                        contextPath.addSegment("allowedUsers"), Optional.empty());
    }

    public PrinterRequest printer() {
        return new PrinterRequest(contextPath.addSegment("printer"), Optional.empty());
    }

}
