package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrinterCreateOperation;

@JsonIgnoreType
public class PrinterCreateOperationRequest extends EntityRequest<PrinterCreateOperation> {

    public PrinterCreateOperationRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrinterCreateOperation.class, contextPath, value, false);
    }

    public PrinterRequest printer() {
        return new PrinterRequest(contextPath.addSegment("printer"), Optional.empty());
    }

}
