package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrintTask;

@JsonIgnoreType
public class PrintTaskRequest extends EntityRequest<PrintTask> {

    public PrintTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrintTask.class, contextPath, value, false);
    }

    public PrintTaskDefinitionRequest definition() {
        return new PrintTaskDefinitionRequest(contextPath.addSegment("definition"), Optional.empty());
    }

    public PrintTaskTriggerRequest trigger() {
        return new PrintTaskTriggerRequest(contextPath.addSegment("trigger"), Optional.empty());
    }

}
