package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrintTaskDefinition;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;

@JsonIgnoreType
public class PrintTaskDefinitionRequest extends EntityRequest<PrintTaskDefinition> {

    public PrintTaskDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrintTaskDefinition.class, contextPath, value, false);
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
