package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Print;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;

@JsonIgnoreType
public class PrintRequest extends EntityRequest<Print> {

    public PrintRequest(ContextPath contextPath, Optional<Object> value) {
        super(Print.class, contextPath, value, false);
    }

    public PrintConnectorRequest connectors(String id) {
        return new PrintConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintConnectorCollectionRequest connectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), Optional.empty());
    }

    public PrintOperationRequest operations(String id) {
        return new PrintOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintOperationCollectionRequest operations() {
        return new PrintOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public PrinterRequest printers(String id) {
        return new PrinterRequest(contextPath.addSegment("printers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrinterCollectionRequest printers() {
        return new PrinterCollectionRequest(
                        contextPath.addSegment("printers"), Optional.empty());
    }

    public PrinterShareRequest printerShares(String id) {
        return new PrinterShareRequest(contextPath.addSegment("printerShares").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrinterShareCollectionRequest printerShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("printerShares"), Optional.empty());
    }

    public ReportRootRequest reports() {
        return new ReportRootRequest(contextPath.addSegment("reports"), Optional.empty());
    }

    public PrintServiceRequest services(String id) {
        return new PrintServiceRequest(contextPath.addSegment("services").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintServiceCollectionRequest services() {
        return new PrintServiceCollectionRequest(
                        contextPath.addSegment("services"), Optional.empty());
    }

    public PrinterShareRequest shares(String id) {
        return new PrinterShareRequest(contextPath.addSegment("shares").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrinterShareCollectionRequest shares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"), Optional.empty());
    }

    public PrintTaskDefinitionRequest taskDefinitions(String id) {
        return new PrintTaskDefinitionRequest(contextPath.addSegment("taskDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskDefinitionCollectionRequest taskDefinitions() {
        return new PrintTaskDefinitionCollectionRequest(
                        contextPath.addSegment("taskDefinitions"), Optional.empty());
    }

}
