package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrintJobConfiguration;
import odata.msgraph.client.beta.complex.PrintJobStatus;
import odata.msgraph.client.beta.entity.PrintJob;
import odata.msgraph.client.beta.entity.collection.request.PrintDocumentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;

@JsonIgnoreType
public class PrintJobRequest extends EntityRequest<PrintJob> {

    public PrintJobRequest(ContextPath contextPath, Optional<Object> value) {
        super(PrintJob.class, contextPath, value, false);
    }

    public PrintDocumentRequest documents(String id) {
        return new PrintDocumentRequest(contextPath.addSegment("documents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintDocumentCollectionRequest documents() {
        return new PrintDocumentCollectionRequest(
                        contextPath.addSegment("documents"), Optional.empty());
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "start")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), PrintJobStatus.class, _parameters);
    }

    @Action(name = "abort")
    @JsonIgnore
    public ActionRequestNoReturn abort(String reason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.abort"), _parameters);
    }

    @Action(name = "cancelPrintJob")
    @JsonIgnore
    public ActionRequestNoReturn cancelPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelPrintJob"), _parameters);
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJob> redirect(String destinationPrinterId, PrintJobConfiguration configuration) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationPrinterId", "Edm.String", Checks.checkIsAscii(destinationPrinterId))
            .put("configuration", "microsoft.graph.printJobConfiguration", configuration)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJob>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), PrintJob.class, _parameters);
    }

    @Action(name = "startPrintJob")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> startPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startPrintJob"), PrintJobStatus.class, _parameters);
    }

}
