package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Presence;

@JsonIgnoreType
public class PresenceRequest extends EntityRequest<Presence> {

    public PresenceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Presence.class, contextPath, value, false);
    }

    @Action(name = "clearPresence")
    @JsonIgnore
    public ActionRequestNoReturn clearPresence(String sessionId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearPresence"), _parameters);
    }

    @Action(name = "clearUserPreferredPresence")
    @JsonIgnore
    public ActionRequestNoReturn clearUserPreferredPresence() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearUserPreferredPresence"), _parameters);
    }

    @Action(name = "setPresence")
    @JsonIgnore
    public ActionRequestNoReturn setPresence(String sessionId, String availability, String activity, Duration expirationDuration) {
        Preconditions.checkNotNull(availability, "availability cannot be null");
        Preconditions.checkNotNull(activity, "activity cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("availability", "Edm.String", Checks.checkIsAscii(availability))
            .put("activity", "Edm.String", Checks.checkIsAscii(activity))
            .put("expirationDuration", "Edm.Duration", expirationDuration)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPresence"), _parameters);
    }

    @Action(name = "setUserPreferredPresence")
    @JsonIgnore
    public ActionRequestNoReturn setUserPreferredPresence(String availability, String activity, Duration expirationDuration) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("availability", "Edm.String", Checks.checkIsAscii(availability))
            .put("activity", "Edm.String", Checks.checkIsAscii(activity))
            .put("expirationDuration", "Edm.Duration", expirationDuration)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUserPreferredPresence"), _parameters);
    }

}
