package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.entity.Post;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MentionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonIgnoreType
public class PostRequest extends EntityRequest<Post> {

    public PostRequest(ContextPath contextPath, Optional<Object> value) {
        super(Post.class, contextPath, value, false);
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public PostRequest inReplyTo() {
        return new PostRequest(contextPath.addSegment("inReplyTo"), Optional.empty());
    }

    public MentionRequest mentions(String id) {
        return new MentionRequest(contextPath.addSegment("mentions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MentionCollectionRequest mentions() {
        return new MentionCollectionRequest(
                        contextPath.addSegment("mentions"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(String comment, List<Recipient> toRecipients) {
        Preconditions.checkNotNull(toRecipients, "toRecipients cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "reply")
    @JsonIgnore
    public ActionRequestNoReturn reply(Post post) {
        Preconditions.checkNotNull(post, "post cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Post", "microsoft.graph.post", post)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reply"), _parameters);
    }

}
