package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerUser;
import odata.msgraph.client.beta.entity.collection.request.PlannerDeltaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonIgnoreType
public class PlannerUserRequest extends EntityRequest<PlannerUser> {

    public PlannerUserRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerUser.class, contextPath, value, false);
    }

    public PlannerDeltaRequest all(String id) {
        return new PlannerDeltaRequest(contextPath.addSegment("all").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerDeltaCollectionRequest all() {
        return new PlannerDeltaCollectionRequest(
                        contextPath.addSegment("all"), Optional.empty());
    }

    public PlannerPlanRequest favoritePlans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("favoritePlans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest favoritePlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("favoritePlans"), Optional.empty());
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), Optional.empty());
    }

    public PlannerPlanRequest recentPlans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("recentPlans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest recentPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("recentPlans"), Optional.empty());
    }

    public PlannerPlanRequest rosterPlans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("rosterPlans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest rosterPlans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("rosterPlans"), Optional.empty());
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
