package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerBucket;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonIgnoreType
public class PlannerBucketRequest extends EntityRequest<PlannerBucket> {

    public PlannerBucketRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerBucket.class, contextPath, value, false);
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
