package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LocaleInfo;
import odata.msgraph.client.beta.complex.TimeZoneInformation;
import odata.msgraph.client.beta.entity.OutlookUser;
import odata.msgraph.client.beta.entity.collection.request.OutlookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskGroupCollectionRequest;
import odata.msgraph.client.beta.enums.TimeZoneStandard;

@JsonIgnoreType
public class OutlookUserRequest extends EntityRequest<OutlookUser> {

    public OutlookUserRequest(ContextPath contextPath, Optional<Object> value) {
        super(OutlookUser.class, contextPath, value, false);
    }

    public OutlookCategoryRequest masterCategories(String id) {
        return new OutlookCategoryRequest(contextPath.addSegment("masterCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookCategoryCollectionRequest masterCategories() {
        return new OutlookCategoryCollectionRequest(
                        contextPath.addSegment("masterCategories"), Optional.empty());
    }

    public OutlookTaskFolderRequest taskFolders(String id) {
        return new OutlookTaskFolderRequest(contextPath.addSegment("taskFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskFolderCollectionRequest taskFolders() {
        return new OutlookTaskFolderCollectionRequest(
                        contextPath.addSegment("taskFolders"), Optional.empty());
    }

    public OutlookTaskGroupRequest taskGroups(String id) {
        return new OutlookTaskGroupRequest(contextPath.addSegment("taskGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskGroupCollectionRequest taskGroups() {
        return new OutlookTaskGroupCollectionRequest(
                        contextPath.addSegment("taskGroups"), Optional.empty());
    }

    public OutlookTaskRequest tasks(String id) {
        return new OutlookTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskCollectionRequest tasks() {
        return new OutlookTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

    @Function(name = "supportedLanguages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<LocaleInfo> supportedLanguages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedLanguages"), LocaleInfo.class, _parameters);
    }

    @Function(name = "supportedTimeZones")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TimeZoneInformation> supportedTimeZones() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedTimeZones"), TimeZoneInformation.class, _parameters);
    }

    @Function(name = "supportedTimeZones")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TimeZoneInformation> supportedTimeZones_Function(TimeZoneStandard timeZoneStandard) {
        Preconditions.checkNotNull(timeZoneStandard, "timeZoneStandard cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TimeZoneStandard", "microsoft.graph.timeZoneStandard", timeZoneStandard)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.supportedTimeZones"), TimeZoneInformation.class, _parameters);
    }

}
