package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutlookTaskGroup;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskFolderCollectionRequest;

@JsonIgnoreType
public class OutlookTaskGroupRequest extends EntityRequest<OutlookTaskGroup> {

    public OutlookTaskGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(OutlookTaskGroup.class, contextPath, value, false);
    }

    public OutlookTaskFolderRequest taskFolders(String id) {
        return new OutlookTaskFolderRequest(contextPath.addSegment("taskFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskFolderCollectionRequest taskFolders() {
        return new OutlookTaskFolderCollectionRequest(
                        contextPath.addSegment("taskFolders"), Optional.empty());
    }

}
