package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OrganizationalBranding;
import odata.msgraph.client.beta.entity.collection.request.OrganizationalBrandingLocalizationCollectionRequest;

@JsonIgnoreType
public class OrganizationalBrandingRequest extends EntityRequest<OrganizationalBranding> {

    public OrganizationalBrandingRequest(ContextPath contextPath, Optional<Object> value) {
        super(OrganizationalBranding.class, contextPath, value, true);
    }

    public OrganizationalBrandingLocalizationRequest localizations(String id) {
        return new OrganizationalBrandingLocalizationRequest(contextPath.addSegment("localizations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OrganizationalBrandingLocalizationCollectionRequest localizations() {
        return new OrganizationalBrandingLocalizationCollectionRequest(
                        contextPath.addSegment("localizations"), Optional.empty());
    }

}
