package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OrganizationSettings;
import odata.msgraph.client.beta.entity.collection.request.ProfileCardPropertyCollectionRequest;

@JsonIgnoreType
public class OrganizationSettingsRequest extends EntityRequest<OrganizationSettings> {

    public OrganizationSettingsRequest(ContextPath contextPath, Optional<Object> value) {
        super(OrganizationSettings.class, contextPath, value, false);
    }

    public InsightsSettingsRequest itemInsights() {
        return new InsightsSettingsRequest(contextPath.addSegment("itemInsights"), Optional.empty());
    }

    public InsightsSettingsRequest peopleInsights() {
        return new InsightsSettingsRequest(contextPath.addSegment("peopleInsights"), Optional.empty());
    }

    public ProfileCardPropertyRequest profileCardProperties(String id) {
        return new ProfileCardPropertyRequest(contextPath.addSegment("profileCardProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProfileCardPropertyCollectionRequest profileCardProperties() {
        return new ProfileCardPropertyCollectionRequest(
                        contextPath.addSegment("profileCardProperties"), Optional.empty());
    }

}
