package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OrgContact;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;

@JsonIgnoreType
public class OrgContactRequest extends EntityRequest<OrgContact> {

    public OrgContactRequest(ContextPath contextPath, Optional<Object> value) {
        super(OrgContact.class, contextPath, value, false);
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("directReports"), Optional.empty());
    }

    public DirectoryObjectRequest manager() {
        return new DirectoryObjectRequest(contextPath.addSegment("manager"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveReports() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveReports"), Optional.empty());
    }

}
