package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Onenote;
import odata.msgraph.client.beta.entity.collection.request.NotebookCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenotePageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;

@JsonIgnoreType
public class OnenoteRequest extends EntityRequest<Onenote> {

    public OnenoteRequest(ContextPath contextPath, Optional<Object> value) {
        super(Onenote.class, contextPath, value, false);
    }

    public NotebookRequest notebooks(String id) {
        return new NotebookRequest(contextPath.addSegment("notebooks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NotebookCollectionRequest notebooks() {
        return new NotebookCollectionRequest(
                        contextPath.addSegment("notebooks"), Optional.empty());
    }

    public OnenoteOperationRequest operations(String id) {
        return new OnenoteOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteOperationCollectionRequest operations() {
        return new OnenoteOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public OnenotePageRequest pages(String id) {
        return new OnenotePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenotePageCollectionRequest pages() {
        return new OnenotePageCollectionRequest(
                        contextPath.addSegment("pages"), Optional.empty());
    }

    public OnenoteResourceRequest resources(String id) {
        return new OnenoteResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteResourceCollectionRequest resources() {
        return new OnenoteResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.empty());
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"), Optional.empty());
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"), Optional.empty());
    }

}
