package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnPremisesPublishingProfile;
import odata.msgraph.client.beta.entity.collection.request.ConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;

@JsonIgnoreType
public class OnPremisesPublishingProfileRequest extends EntityRequest<OnPremisesPublishingProfile> {

    public OnPremisesPublishingProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(OnPremisesPublishingProfile.class, contextPath, value, false);
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"), Optional.empty());
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"), Optional.empty());
    }

    public ConnectorGroupRequest connectorGroups(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorGroupCollectionRequest connectorGroups() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("connectorGroups"), Optional.empty());
    }

    public ConnectorRequest connectors(String id) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorCollectionRequest connectors() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("connectors"), Optional.empty());
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"), Optional.empty());
    }

}
