package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OemWarrantyInformationOnboarding;

@JsonIgnoreType
public class OemWarrantyInformationOnboardingRequest extends EntityRequest<OemWarrantyInformationOnboarding> {

    public OemWarrantyInformationOnboardingRequest(ContextPath contextPath, Optional<Object> value) {
        super(OemWarrantyInformationOnboarding.class, contextPath, value, false);
    }

    @Action(name = "disable")
    @JsonIgnore
    public ActionRequestNoReturn disable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disable"), _parameters);
    }

    @Action(name = "enable")
    @JsonIgnore
    public ActionRequestNoReturn enable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enable"), _parameters);
    }

}
