package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobilityManagementPolicy;
import odata.msgraph.client.beta.entity.collection.request.GroupCollectionRequest;

@JsonIgnoreType
public class MobilityManagementPolicyRequest extends EntityRequest<MobilityManagementPolicy> {

    public MobilityManagementPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(MobilityManagementPolicy.class, contextPath, value, false);
    }

    public GroupRequest includedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("includedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest includedGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("includedGroups"), Optional.empty());
    }

}
