package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobileLobApp;
import odata.msgraph.client.beta.entity.collection.request.MobileAppContentCollectionRequest;

@JsonIgnoreType
public class MobileLobAppRequest extends EntityRequest<MobileLobApp> {

    public MobileLobAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(MobileLobApp.class, contextPath, value, false);
    }

    public MobileAppContentRequest contentVersions(String id) {
        return new MobileAppContentRequest(contextPath.addSegment("contentVersions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppContentCollectionRequest contentVersions() {
        return new MobileAppContentCollectionRequest(
                        contextPath.addSegment("contentVersions"), Optional.empty());
    }

}
