package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest;

@JsonIgnoreType
public class MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest extends EntityRequest<MicrosoftAuthenticatorAuthenticationMethodConfiguration> {

    public MicrosoftAuthenticatorAuthenticationMethodConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(MicrosoftAuthenticatorAuthenticationMethodConfiguration.class, contextPath, value, false);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTargetRequest includeTargets(String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetRequest(contextPath.addSegment("includeTargets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest includeTargets() {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.empty());
    }

}
