package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MessageRecipient;
import odata.msgraph.client.beta.entity.collection.request.MessageEventCollectionRequest;

@JsonIgnoreType
public class MessageRecipientRequest extends EntityRequest<MessageRecipient> {

    public MessageRecipientRequest(ContextPath contextPath, Optional<Object> value) {
        super(MessageRecipient.class, contextPath, value, false);
    }

    public MessageEventRequest events(String id) {
        return new MessageEventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageEventCollectionRequest events() {
        return new MessageEventCollectionRequest(
                        contextPath.addSegment("events"), Optional.empty());
    }

}
