package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MeetingRegistrationBase;
import odata.msgraph.client.beta.entity.collection.request.MeetingRegistrantBaseCollectionRequest;

@JsonIgnoreType
public class MeetingRegistrationBaseRequest extends EntityRequest<MeetingRegistrationBase> {

    public MeetingRegistrationBaseRequest(ContextPath contextPath, Optional<Object> value) {
        super(MeetingRegistrationBase.class, contextPath, value, false);
    }

    public MeetingRegistrantBaseRequest registrants(String id) {
        return new MeetingRegistrantBaseRequest(contextPath.addSegment("registrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MeetingRegistrantBaseCollectionRequest registrants() {
        return new MeetingRegistrantBaseCollectionRequest(
                        contextPath.addSegment("registrants"), Optional.empty());
    }

}
