package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ManagementConditionExpressionString;
import odata.msgraph.client.beta.entity.ManagementConditionStatement;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;

@JsonIgnoreType
public class ManagementConditionStatementRequest extends EntityRequest<ManagementConditionStatement> {

    public ManagementConditionStatementRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementConditionStatement.class, contextPath, value, false);
    }

    public ManagementConditionRequest managementConditions(String id) {
        return new ManagementConditionRequest(contextPath.addSegment("managementConditions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementConditionCollectionRequest managementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"), Optional.empty());
    }

    @Function(name = "getManagementConditionStatementExpressionString")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString> getManagementConditionStatementExpressionString() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ManagementConditionExpressionString>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagementConditionStatementExpressionString"), ManagementConditionExpressionString.class, _parameters);
    }

}
