package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagementCondition;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;

@JsonIgnoreType
public class ManagementConditionRequest extends EntityRequest<ManagementCondition> {

    public ManagementConditionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementCondition.class, contextPath, value, false);
    }

    public ManagementConditionStatementRequest managementConditionStatements(String id) {
        return new ManagementConditionStatementRequest(contextPath.addSegment("managementConditionStatements").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementConditionStatementCollectionRequest managementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"), Optional.empty());
    }

}
