package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedEBook;
import odata.msgraph.client.beta.entity.ManagedEBookAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceInstallStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserInstallStateSummaryCollectionRequest;

@JsonIgnoreType
public class ManagedEBookRequest extends EntityRequest<ManagedEBook> {

    public ManagedEBookRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagedEBook.class, contextPath, value, false);
    }

    public ManagedEBookAssignmentRequest assignments(String id) {
        return new ManagedEBookAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedEBookAssignmentCollectionRequest assignments() {
        return new ManagedEBookAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public ManagedEBookCategoryRequest categories(String id) {
        return new ManagedEBookCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedEBookCategoryCollectionRequest categories() {
        return new ManagedEBookCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.empty());
    }

    public EBookInstallSummaryRequest installSummary() {
        return new EBookInstallSummaryRequest(contextPath.addSegment("installSummary"), Optional.empty());
    }

    public UserInstallStateSummaryRequest userStateSummary(String id) {
        return new UserInstallStateSummaryRequest(contextPath.addSegment("userStateSummary").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserInstallStateSummaryCollectionRequest userStateSummary() {
        return new UserInstallStateSummaryCollectionRequest(
                        contextPath.addSegment("userStateSummary"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<ManagedEBookAssignment> managedEBookAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedEBookAssignments", "Collection(microsoft.graph.managedEBookAssignment)", managedEBookAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
