package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcRemoteActionResult;
import odata.msgraph.client.beta.complex.ConfigurationManagerAction;
import odata.msgraph.client.beta.complex.DeviceCompliancePolicySettingState;
import odata.msgraph.client.beta.complex.DeviceLogCollectionRequest;
import odata.msgraph.client.beta.complex.OemWarranty;
import odata.msgraph.client.beta.complex.UpdateWindowsDeviceAccountActionParameter;
import odata.msgraph.client.beta.entity.DeviceLogCollectionResponse;
import odata.msgraph.client.beta.entity.ManagedDevice;
import odata.msgraph.client.beta.entity.collection.request.AssignmentFilterEvaluationStatusDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceLogCollectionResponseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;
import odata.msgraph.client.beta.enums.AdministratorConfiguredDeviceComplianceState;

@JsonIgnoreType
public class ManagedDeviceRequest extends EntityRequest<ManagedDevice> {

    public ManagedDeviceRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagedDevice.class, contextPath, value, false);
    }

    public AssignmentFilterEvaluationStatusDetailsRequest assignmentFilterEvaluationStatusDetails(String id) {
        return new AssignmentFilterEvaluationStatusDetailsRequest(contextPath.addSegment("assignmentFilterEvaluationStatusDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AssignmentFilterEvaluationStatusDetailsCollectionRequest assignmentFilterEvaluationStatusDetails() {
        return new AssignmentFilterEvaluationStatusDetailsCollectionRequest(
                        contextPath.addSegment("assignmentFilterEvaluationStatusDetails"), Optional.empty());
    }

    public DeviceCompliancePolicyStateRequest deviceCompliancePolicyStates(String id) {
        return new DeviceCompliancePolicyStateRequest(contextPath.addSegment("deviceCompliancePolicyStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicyStateCollectionRequest deviceCompliancePolicyStates() {
        return new DeviceCompliancePolicyStateCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicyStates"), Optional.empty());
    }

    public DeviceConfigurationStateRequest deviceConfigurationStates(String id) {
        return new DeviceConfigurationStateRequest(contextPath.addSegment("deviceConfigurationStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationStateCollectionRequest deviceConfigurationStates() {
        return new DeviceConfigurationStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationStates"), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationStateRequest managedDeviceMobileAppConfigurationStates(String id) {
        return new ManagedDeviceMobileAppConfigurationStateRequest(contextPath.addSegment("managedDeviceMobileAppConfigurationStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceMobileAppConfigurationStateCollectionRequest managedDeviceMobileAppConfigurationStates() {
        return new ManagedDeviceMobileAppConfigurationStateCollectionRequest(
                        contextPath.addSegment("managedDeviceMobileAppConfigurationStates"), Optional.empty());
    }

    public SecurityBaselineStateRequest securityBaselineStates(String id) {
        return new SecurityBaselineStateRequest(contextPath.addSegment("securityBaselineStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SecurityBaselineStateCollectionRequest securityBaselineStates() {
        return new SecurityBaselineStateCollectionRequest(
                        contextPath.addSegment("securityBaselineStates"), Optional.empty());
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"), Optional.empty());
    }

    public DeviceCategoryRequest deviceCategory() {
        return new DeviceCategoryRequest(contextPath.addSegment("deviceCategory"), Optional.empty());
    }

    public DeviceLogCollectionResponseRequest logCollectionRequests(String id) {
        return new DeviceLogCollectionResponseRequest(contextPath.addSegment("logCollectionRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceLogCollectionResponseCollectionRequest logCollectionRequests() {
        return new DeviceLogCollectionResponseCollectionRequest(
                        contextPath.addSegment("logCollectionRequests"), Optional.empty());
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest users() {
        return new UserCollectionRequest(
                        contextPath.addSegment("users"), Optional.empty());
    }

    public WindowsProtectionStateRequest windowsProtectionState() {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsProtectionState"), Optional.empty());
    }

    @Action(name = "reprovisionCloudPc")
    @JsonIgnore
    public ActionRequestNoReturn reprovisionCloudPc() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprovisionCloudPc"), _parameters);
    }

    @Action(name = "resizeCloudPc")
    @JsonIgnore
    public ActionRequestNoReturn resizeCloudPc(String targetServicePlanId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("targetServicePlanId", "Edm.String", Checks.checkIsAscii(targetServicePlanId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resizeCloudPc"), _parameters);
    }

    @Action(name = "restoreCloudPc")
    @JsonIgnore
    public ActionRequestNoReturn restoreCloudPc(String cloudPcSnapshotId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cloudPcSnapshotId", "Edm.String", Checks.checkIsAscii(cloudPcSnapshotId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restoreCloudPc"), _parameters);
    }

    @Action(name = "overrideComplianceState")
    @JsonIgnore
    public ActionRequestNoReturn overrideComplianceState(AdministratorConfiguredDeviceComplianceState complianceState, String remediationUrl) {
        Preconditions.checkNotNull(complianceState, "complianceState cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("complianceState", "microsoft.graph.administratorConfiguredDeviceComplianceState", complianceState)
            .put("remediationUrl", "Edm.String", Checks.checkIsAscii(remediationUrl))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.overrideComplianceState"), _parameters);
    }

    @Action(name = "activateDeviceEsim")
    @JsonIgnore
    public ActionRequestNoReturn activateDeviceEsim(String carrierUrl) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("carrierUrl", "Edm.String", Checks.checkIsAscii(carrierUrl))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.activateDeviceEsim"), _parameters);
    }

    @Action(name = "bypassActivationLock")
    @JsonIgnore
    public ActionRequestNoReturn bypassActivationLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.bypassActivationLock"), _parameters);
    }

    @Action(name = "cleanWindowsDevice")
    @JsonIgnore
    public ActionRequestNoReturn cleanWindowsDevice(Boolean keepUserData) {
        Preconditions.checkNotNull(keepUserData, "keepUserData cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cleanWindowsDevice"), _parameters);
    }

    @Action(name = "createDeviceLogCollectionRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse> createDeviceLogCollectionRequest(DeviceLogCollectionRequest templateType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateType", "microsoft.graph.deviceLogCollectionRequest", templateType)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceLogCollectionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDeviceLogCollectionRequest"), DeviceLogCollectionResponse.class, _parameters);
    }

    @Action(name = "deleteUserFromSharedAppleDevice")
    @JsonIgnore
    public ActionRequestNoReturn deleteUserFromSharedAppleDevice(String userPrincipalName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deleteUserFromSharedAppleDevice"), _parameters);
    }

    @Action(name = "deprovision")
    @JsonIgnore
    public ActionRequestNoReturn deprovision(String deprovisionReason) {
        Preconditions.checkNotNull(deprovisionReason, "deprovisionReason cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deprovisionReason", "Edm.String", Checks.checkIsAscii(deprovisionReason))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deprovision"), _parameters);
    }

    @Action(name = "disable")
    @JsonIgnore
    public ActionRequestNoReturn disable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disable"), _parameters);
    }

    @Action(name = "disableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn disableLostMode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disableLostMode"), _parameters);
    }

    @Action(name = "enableLostMode")
    @JsonIgnore
    public ActionRequestNoReturn enableLostMode(String message, String phoneNumber, String footer) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("phoneNumber", "Edm.String", Checks.checkIsAscii(phoneNumber))
            .put("footer", "Edm.String", Checks.checkIsAscii(footer))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLostMode"), _parameters);
    }

    @Action(name = "locateDevice")
    @JsonIgnore
    public ActionRequestNoReturn locateDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.locateDevice"), _parameters);
    }

    @Action(name = "logoutSharedAppleDeviceActiveUser")
    @JsonIgnore
    public ActionRequestNoReturn logoutSharedAppleDeviceActiveUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.logoutSharedAppleDeviceActiveUser"), _parameters);
    }

    @Action(name = "playLostModeSound")
    @JsonIgnore
    public ActionRequestNoReturn playLostModeSound(String durationInMinutes) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("durationInMinutes", "Edm.String", Checks.checkIsAscii(durationInMinutes))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.playLostModeSound"), _parameters);
    }

    @Action(name = "rebootNow")
    @JsonIgnore
    public ActionRequestNoReturn rebootNow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rebootNow"), _parameters);
    }

    @Action(name = "recoverPasscode")
    @JsonIgnore
    public ActionRequestNoReturn recoverPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recoverPasscode"), _parameters);
    }

    @Action(name = "reenable")
    @JsonIgnore
    public ActionRequestNoReturn reenable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reenable"), _parameters);
    }

    @Action(name = "remoteLock")
    @JsonIgnore
    public ActionRequestNoReturn remoteLock() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remoteLock"), _parameters);
    }

    @Action(name = "requestRemoteAssistance")
    @JsonIgnore
    public ActionRequestNoReturn requestRemoteAssistance() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestRemoteAssistance"), _parameters);
    }

    @Action(name = "resetPasscode")
    @JsonIgnore
    public ActionRequestNoReturn resetPasscode() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetPasscode"), _parameters);
    }

    @Action(name = "retire")
    @JsonIgnore
    public ActionRequestNoReturn retire() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.retire"), _parameters);
    }

    @Action(name = "revokeAppleVppLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeAppleVppLicenses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeAppleVppLicenses"), _parameters);
    }

    @Action(name = "rotateBitLockerKeys")
    @JsonIgnore
    public ActionRequestNoReturn rotateBitLockerKeys() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateBitLockerKeys"), _parameters);
    }

    @Action(name = "rotateFileVaultKey")
    @JsonIgnore
    public ActionRequestNoReturn rotateFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rotateFileVaultKey"), _parameters);
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody) {
        Preconditions.checkNotNull(notificationTitle, "notificationTitle cannot be null");
        Preconditions.checkNotNull(notificationBody, "notificationBody cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Action(name = "setDeviceName")
    @JsonIgnore
    public ActionRequestNoReturn setDeviceName(String deviceName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceName", "Edm.String", Checks.checkIsAscii(deviceName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setDeviceName"), _parameters);
    }

    @Action(name = "shutDown")
    @JsonIgnore
    public ActionRequestNoReturn shutDown() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.shutDown"), _parameters);
    }

    @Action(name = "syncDevice")
    @JsonIgnore
    public ActionRequestNoReturn syncDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncDevice"), _parameters);
    }

    @Action(name = "triggerConfigurationManagerAction")
    @JsonIgnore
    public ActionRequestNoReturn triggerConfigurationManagerAction(ConfigurationManagerAction configurationManagerAction) {
        Preconditions.checkNotNull(configurationManagerAction, "configurationManagerAction cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("configurationManagerAction", "microsoft.graph.configurationManagerAction", configurationManagerAction)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.triggerConfigurationManagerAction"), _parameters);
    }

    @Action(name = "updateWindowsDeviceAccount")
    @JsonIgnore
    public ActionRequestNoReturn updateWindowsDeviceAccount(UpdateWindowsDeviceAccountActionParameter updateWindowsDeviceAccountActionParameter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("updateWindowsDeviceAccountActionParameter", "microsoft.graph.updateWindowsDeviceAccountActionParameter", updateWindowsDeviceAccountActionParameter)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateWindowsDeviceAccount"), _parameters);
    }

    @Action(name = "windowsDefenderScan")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderScan(Boolean quickScan) {
        Preconditions.checkNotNull(quickScan, "quickScan cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("quickScan", "Edm.Boolean", quickScan)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderScan"), _parameters);
    }

    @Action(name = "windowsDefenderUpdateSignatures")
    @JsonIgnore
    public ActionRequestNoReturn windowsDefenderUpdateSignatures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsDefenderUpdateSignatures"), _parameters);
    }

    @Action(name = "wipe")
    @JsonIgnore
    public ActionRequestNoReturn wipe(Boolean keepEnrollmentData, Boolean keepUserData, String macOsUnlockCode, Boolean persistEsimDataPlan, Boolean useProtectedWipe) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keepEnrollmentData", "Edm.Boolean", keepEnrollmentData)
            .put("keepUserData", "Edm.Boolean", keepUserData)
            .put("macOsUnlockCode", "Edm.String", Checks.checkIsAscii(macOsUnlockCode))
            .put("persistEsimDataPlan", "Edm.Boolean", persistEsimDataPlan)
            .put("useProtectedWipe", "Edm.Boolean", useProtectedWipe)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.wipe"), _parameters);
    }

    @Function(name = "getCloudPcRemoteActionResults")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CloudPcRemoteActionResult> getCloudPcRemoteActionResults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCloudPcRemoteActionResults"), CloudPcRemoteActionResult.class, _parameters);
    }

    @Function(name = "getNonCompliantSettings")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceCompliancePolicySettingState> getNonCompliantSettings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getNonCompliantSettings"), DeviceCompliancePolicySettingState.class, _parameters);
    }

    @Function(name = "getFileVaultKey")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getFileVaultKey() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getFileVaultKey"), String.class, _parameters);
    }

    @Function(name = "getOemWarranty")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<OemWarranty> getOemWarranty() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<OemWarranty>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOemWarranty"), OemWarranty.class, _parameters);
    }

}
