package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedAppPolicy;
import odata.msgraph.client.beta.entity.ManagedMobileApp;

@JsonIgnoreType
public class ManagedAppPolicyRequest extends EntityRequest<ManagedAppPolicy> {

    public ManagedAppPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagedAppPolicy.class, contextPath, value, false);
    }

    @Action(name = "targetApps")
    @JsonIgnore
    public ActionRequestNoReturn targetApps(List<ManagedMobileApp> apps) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("apps", "Collection(microsoft.graph.managedMobileApp)", apps)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.targetApps"), _parameters);
    }

}
