package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MailFolder;
import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserConfigurationCollectionRequest;

@JsonIgnoreType
public class MailFolderRequest extends EntityRequest<MailFolder> {

    public MailFolderRequest(ContextPath contextPath, Optional<Object> value) {
        super(MailFolder.class, contextPath, value, false);
    }

    public MailFolderRequest childFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("childFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MailFolderCollectionRequest childFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("childFolders"), Optional.empty());
    }

    public MessageRuleRequest messageRules(String id) {
        return new MessageRuleRequest(contextPath.addSegment("messageRules").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageRuleCollectionRequest messageRules() {
        return new MessageRuleCollectionRequest(
                        contextPath.addSegment("messageRules"), Optional.empty());
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    public UserConfigurationRequest userConfigurations(String id) {
        return new UserConfigurationRequest(contextPath.addSegment("userConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserConfigurationCollectionRequest userConfigurations() {
        return new UserConfigurationCollectionRequest(
                        contextPath.addSegment("userConfigurations"), Optional.empty());
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> copy(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), MailFolder.class, _parameters);
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> move(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), MailFolder.class, _parameters);
    }

}
