package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOsVppApp;
import odata.msgraph.client.beta.entity.collection.request.MacOsVppAppAssignedLicenseCollectionRequest;

@JsonIgnoreType
public class MacOsVppAppRequest extends EntityRequest<MacOsVppApp> {

    public MacOsVppAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOsVppApp.class, contextPath, value, false);
    }

    public MacOsVppAppAssignedLicenseRequest assignedLicenses(String id) {
        return new MacOsVppAppAssignedLicenseRequest(contextPath.addSegment("assignedLicenses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOsVppAppAssignedLicenseCollectionRequest assignedLicenses() {
        return new MacOsVppAppAssignedLicenseCollectionRequest(
                        contextPath.addSegment("assignedLicenses"), Optional.empty());
    }

}
