package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSWiredNetworkConfiguration;

@JsonIgnoreType
public class MacOSWiredNetworkConfigurationRequest extends EntityRequest<MacOSWiredNetworkConfiguration> {

    public MacOSWiredNetworkConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOSWiredNetworkConfiguration.class, contextPath, value, false);
    }

    public MacOSCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public MacOSTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"), Optional.empty());
    }

}
