package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSSoftwareUpdateCategorySummary;
import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateStateSummaryCollectionRequest;

@JsonIgnoreType
public class MacOSSoftwareUpdateCategorySummaryRequest extends EntityRequest<MacOSSoftwareUpdateCategorySummary> {

    public MacOSSoftwareUpdateCategorySummaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOSSoftwareUpdateCategorySummary.class, contextPath, value, false);
    }

    public MacOSSoftwareUpdateStateSummaryRequest updateStateSummaries(String id) {
        return new MacOSSoftwareUpdateStateSummaryRequest(contextPath.addSegment("updateStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSSoftwareUpdateStateSummaryCollectionRequest updateStateSummaries() {
        return new MacOSSoftwareUpdateStateSummaryCollectionRequest(
                        contextPath.addSegment("updateStateSummaries"), Optional.empty());
    }

}
