package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSEnterpriseWiFiConfiguration;
import odata.msgraph.client.beta.entity.collection.request.MacOSTrustedRootCertificateCollectionRequest;

@JsonIgnoreType
public class MacOSEnterpriseWiFiConfigurationRequest extends EntityRequest<MacOSEnterpriseWiFiConfiguration> {

    public MacOSEnterpriseWiFiConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOSEnterpriseWiFiConfiguration.class, contextPath, value, false);
    }

    public MacOSCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public MacOSTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"), Optional.empty());
    }

    public MacOSTrustedRootCertificateRequest rootCertificatesForServerValidation(String id) {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificatesForServerValidation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSTrustedRootCertificateCollectionRequest rootCertificatesForServerValidation() {
        return new MacOSTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"), Optional.empty());
    }

}
