package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityCollectionRequest;

@JsonIgnoreType
public class ItemActivityStatRequest extends EntityRequest<ItemActivityStat> {

    public ItemActivityStatRequest(ContextPath contextPath, Optional<Object> value) {
        super(ItemActivityStat.class, contextPath, value, false);
    }

    public ItemActivityRequest activities(String id) {
        return new ItemActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityCollectionRequest activities() {
        return new ItemActivityCollectionRequest(
                        contextPath.addSegment("activities"), Optional.empty());
    }

}
