package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ItemActivityOLD;

@JsonIgnoreType
public class ItemActivityOLDRequest extends EntityRequest<ItemActivityOLD> {

    public ItemActivityOLDRequest(ContextPath contextPath, Optional<Object> value) {
        super(ItemActivityOLD.class, contextPath, value, false);
    }

    public DriveItemRequest driveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"), Optional.empty());
    }

    public ListItemRequest listItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"), Optional.empty());
    }

}
