package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosVpnConfiguration;

@JsonIgnoreType
public class IosVpnConfigurationRequest extends EntityRequest<IosVpnConfiguration> {

    public IosVpnConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosVpnConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

    public IosCertificateProfileBaseRequest identityCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), Optional.empty());
    }

}
